/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.va.med.term.cvx.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import gov.vha.isaac.ochre.api.State;

/**
 * 
 * {@link CVXCodesHelper}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class CVXCodesHelper {
	private CVXCodesHelper() {}

	public static String getShortDescription(CVXCodes.CVXInfo info) {
		return info.shortDescription != null ? info.shortDescription.trim() : null;
	}

	/**
	 * Gets the value of the fullVaccinename property.
	 * 
	 * @return
	 *     possible object is
	 *     {@link String }
	 *     
	 */
	public static String getFullVaccinename(CVXCodes.CVXInfo info) {
		return info.fullVaccinename != null ? info.fullVaccinename.trim() : null;
	}

	/**
	 * Gets the value of the cvxCode property.
	 * 
	 */
	public static int getCVXCode(CVXCodes.CVXInfo info) {
		return info.cvxCode;
	}

	/**
	 * Gets the value of the notes property.
	 * 
	 * @return
	 *     possible object is
	 *     {@link String }
	 *     
	 */
	public static String getNotes(CVXCodes.CVXInfo info) {
		return info.getNotes() != null ? info.getNotes().trim() : null;
	}

	/**
	 * Gets the value of the status property.
	 * 
	 * @return
	 *     possible object is
	 *     {@link String }
	 *     
	 */
	public static String getStatus(CVXCodes.CVXInfo info) {
		return info.getStatus() != null ? info.getStatus().trim() : null;
	}

	/**
	 * Gets the Ochre State value of the status property.
	 * 
	 * @return
	 *     possible object is
	 *     {@link gov.vha.isaac.ochre.api.State }
	 *     
	 */
	public static State getOchreState(CVXCodes.CVXInfo info) {
		/*
		 * "Active", "Inactive", "Never Active", "Non-US" and "Pending"
		 */
		String status = getStatus(info).toUpperCase();
		if (status.equals("ACTIVE") || status.equals("INACTIVE")) {
			return State.valueOf(status);
		} else if (status.equals("NEVER ACTIVE")) {
			return State.INACTIVE;
		} else if (status.equals("NON-US")) {
			return State.ACTIVE;
		} else if (status.equals("PENDING")) {
			return State.ACTIVE;
		} else {
			throw new RuntimeException("Unexpected MVX Status \"" + getStatus(info) + "\" in entry: " + info);
		}
	}

	/**
	 * Gets the value of the lastUpdated property.
	 * 
	 * @return
	 *     possible object is
	 *     {@link String }
	 *     
	 */
	public static Date getLastUpdatedDate(CVXCodes.CVXInfo info) throws ParseException {
		DateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		return df.parse(info.getLastUpdated()); 
	}
}
